﻿namespace Microsoft.Samples.PlanMyNight.Web
{
    using System;
    using System.ComponentModel.Composition;
    using System.Configuration;
    using System.Web;
    using System.Web.Security;
    using Microsoft.Samples.PlanMyNight.Bing;
    using Microsoft.Samples.PlanMyNight.Data;
    using Microsoft.Samples.PlanMyNight.Data.Caching;

    [Export(typeof(IServiceFactory))]
    [PartCreationPolicy(CreationPolicy.NonShared)]
    public class ServiceFactory : IServiceFactory
    {
        private static ICachingProvider cachingProvider;

        public IReferenceRepository GetReferenceRepositoryInstance()
        {
            return new CachedReferenceRepository(
                GetCachingProvider(),
                new ReferenceRepository());
        }

        public IMembershipService GetMembershipService()
        {
            return new AccountMembershipService(Membership.Provider, GetCachingProvider(), new HttpContextWrapper(HttpContext.Current));
        }

        public IActivitiesRepository GetActivitiesRepositoryInstance()
        {
            return new CachedActivitiesRepository(
                GetCachingProvider(),
                new BingActivitiesRepository(new BingMapsService()));
        }

        public IItinerariesRepository GetItinerariesRepositoryInstance()
        {
            return new CachedItinerariesRepository(
                GetCachingProvider(),
                new ItinerariesRepository());
        }

        public IItineraryContainer GetItineraryContainerInstance()
        {
            return new SessionItineraryContainer(new HttpContextWrapper(HttpContext.Current));
        }

        private static ICachingProvider GetCachingProvider()
        {
            if (cachingProvider == null)
            {
                var typeAssembly = ConfigurationManager.AppSettings["Caching.Provider"].Split(',');
                cachingProvider = (ICachingProvider)Activator.CreateInstance(typeAssembly[1], typeAssembly[0], null).Unwrap();
            }

            return cachingProvider;
        }
    }
}
